function [X_start,Y_start,Shape_Pts,Shift,Shape_stp]=Steering_Shape_Points(core,File_N)

% This function feeding the shape points and steps to the steering code 
% so that the particle will be manipulated from the start poiont to single/multiple
% target depends on how many shape points are identified. The starting
% point is the required particle to be tracked and manipulated.

% specify file number to save all data and images
my_dir='F:\SteeringControl\Steer (';

Shift=400;% distance between any two points in pixels 

% Input pop message for specifing shape point numbers as the following:
% 1 = random normal manipulation
% 2 = two mid way points between 1st & target point 
% 3 = triangular shape 
% 4 = noraml square shape (4 shape points), with 8 starting point 
% options: 
% [1,2,3 and 4] is clockwise manipualtion direction
% [5,6,7 and 8] is anticlockwise manipualtion direction
%  where point 1 is same as point 5 and so on.

% 10 =  bing bong 10 iterations between start and target point.
% 11 = fixed line distance with diferent direction 
% 12 = square shape with mid way points (12 points in total)

prompt3 = {'shape stps'};
dlg_title3 = 'shape stps';
Shape_stp=str2double(inputdlg(prompt3,dlg_title3));

if Shape_stp==4 % from which point the squar starts (1,2,3 ...8).
prompt4 = {'SQUARE OPTION'};
dlg_title4 = 'SQUARE OPTION';
OPTION=str2double(inputdlg(prompt4,dlg_title4));

prompt5 = {'SQUARE number'};
dlg_title5 = 'SQUARE number';
Squ_Num=str2double(inputdlg(prompt5,dlg_title5));
end

img=Snap_Image(core); % snap the start image
imwrite(img,[my_dir,num2str(File_N),')\img(1).jpg']);% save the starting postion image
imshow(img);% show image to select points
% selecting starting & target position by right clicking the mouse.
[X_s,Y_s] = getpts;
[X_start,Y_start]=Search_bead(img,10,X_s,Y_s);

if Shape_stp==1 % random normal manipulation 
    [X_1,Y_1] = getpts;% assign final target
    Shape_Pts=[X_1 Y_1];

elseif Shape_stp==2 % two mid way points between 1st & target point
        [X_3,Y_3] = getpts;% assign final target
        Delta_x=X_3-X_start;
        Delta_y=Y_3-Y_start;
        dir = wrapTo2Pi(atan2(Delta_y,Delta_x));% LINE direction
        L=sqrt((Delta_x)^2+(Delta_y)^2);
        shift=L/3;
        X_1=shift*(cos(dir))+X_start;
        Y_1=shift*(sin(dir))+Y_start;
        X_2=2*shift*(cos(dir))+X_start;
        Y_2=2*shift*(sin(dir))+Y_start;
        Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3] ; 
        Shape_stp=3;

elseif Shape_stp==3 % triangular shape
        X_1=X_start+Shift; 
        Y_1=Y_start;
        X_2=X_start;
        Y_2=Y_1+Shift;
        X_3=X_start;
        Y_3=Y_start;
        Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3];
        
elseif Shape_stp==4 % noraml square shape (4 shape points) 

    Shape_stp=Shape_stp*Squ_Num;
    
            if OPTION==1
                %OP1% Squar starts from upper left corner (clockwise)
                X_1=X_start+Shift; 
                Y_1=Y_start;
                X_2=X_1;
                Y_2=Y_1+Shift;
                X_3=X_start;
                Y_3=Y_2;
                X_4=X_start;
                Y_4=Y_start;
                    

                Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4];
                Shape_Pts = repmat(Shape_Pts,Squ_Num,1);
                
                

            elseif OPTION==2 
                    %OP2% Squar starts from upper righ corner (clockwise)
                    X_1=X_start; 
                    Y_1=Y_start+Shift;
                    X_2=X_1-Shift;
                    Y_2=Y_1;
                    X_3=X_2;
                    Y_3=Y_2-Shift;
                    X_4=X_start;
                    Y_4=Y_start;
                    Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4];
                    Shape_Pts = repmat(Shape_Pts,Squ_Num,1);

            elseif OPTION==3
                    %OP3% Squar starts from lower right corner (clockwise)
                    X_1=X_start-Shift; 
                    Y_1=Y_start;
                    X_2=X_1;
                    Y_2=Y_1-Shift;
                    X_3=X_start;
                    Y_3=Y_2;
                    X_4=X_start;
                    Y_4=Y_start;
                    Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4];
                    Shape_Pts = repmat(Shape_Pts,Squ_Num,1);

            elseif OPTION==4 
                    %OP4% Squar starts from lower left corner (clockwise)
                    X_1=X_start; 
                    Y_1=Y_start-Shift;
                    X_2=X_1+Shift;
                    Y_2=Y_1;
                    X_3=X_2;
                    Y_3=Y_2+Shift;
                    X_4=X_start;
                    Y_4=Y_start;
                    Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4];
                    Shape_Pts = repmat(Shape_Pts,Squ_Num,1);
                
            elseif OPTION==5
                    %OP5% Squar starts from upper left corner (anticlockwise)
                    X_1=X_start; 
                    Y_1=Y_start+Shift;
                    X_2=X_1+Shift;
                    Y_2=Y_1;
                    X_3=X_2;
                    Y_3=Y_2-Shift;
                    X_4=X_start;
                    Y_4=Y_start;
                    Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4];
                    Shape_Pts = repmat(Shape_Pts,Squ_Num,1);

            elseif OPTION==6 
                    %OP6% Squar starts from upper righ corner (anticlockwise)
                    X_1=X_start-Shift; 
                    Y_1=Y_start;
                    X_2=X_1;
                    Y_2=Y_1+Shift;
                    X_3=X_2+Shift;
                    Y_3=Y_2;
                    X_4=X_start;
                    Y_4=Y_start;
                    Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4];
                    Shape_Pts = repmat(Shape_Pts,Squ_Num,1);

            elseif OPTION==7
                    %OP7% Squar starts from lower right corner (anticlockwise)
                    X_1=X_start; 
                    Y_1=Y_start-Shift;
                    X_2=X_1-Shift;
                    Y_2=Y_1;
                    X_3=X_2;
                    Y_3=Y_2+Shift;
                    X_4=X_start;
                    Y_4=Y_start;
                    Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4];
                    Shape_Pts = repmat(Shape_Pts,Squ_Num,1);

            else 
                %OP8% Squar starts from lower left corner (anticlockwise)
                X_1=X_start+Shift; 
                Y_1=Y_start;
                X_2=X_1;
                Y_2=Y_1-Shift;
                X_3=X_2-Shift;
                Y_3=Y_2;
                X_4=X_start;
                Y_4=Y_start;
                Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4];
                Shape_Pts = repmat(Shape_Pts,Squ_Num,1);
            end        

elseif Shape_stp==10 % bing bong 10 iterations back to start point. 
    [X_1,Y_1] = getpts;% assign final target
    Shape_Pts=[X_1 Y_1;X_start Y_start;X_1 Y_1;X_start Y_start;X_1 Y_1;X_start Y_start ...
        ;X_1 Y_1;X_start Y_start;X_1 Y_1;X_start Y_start];
            
        
elseif Shape_stp==12 % square shape with mid way points    
    
    prompt1 = {'Square Direction'};
    dlg_title1 = 'Square Direction';
    dir1=str2double(inputdlg(prompt1,dlg_title1));
    dir=[dir1 dir1+1.57 dir1+3.14 dir1+4.71];
    shift=Shift/3;
    %%% first Leg
    dir1=dir(1);
    X_1=shift*(cos(dir1))+X_start;
    Y_1=shift*(sin(dir1))+Y_start;
    X_2=2*shift*(cos(dir1))+X_start;
    Y_2=2*shift*(sin(dir1))+Y_start;
    X_3=3*shift*(cos(dir1))+X_start;
    Y_3=3*shift*(sin(dir1))+Y_start;
    
    %%% second Leg
    dir2=dir(2);
    X_4=shift*(cos(dir2))+X_3;
    Y_4=shift*(sin(dir2))+Y_3;
    X_5=2*shift*(cos(dir2))+X_3;
    Y_5=2*shift*(sin(dir2))+Y_3;
    X_6=3*shift*(cos(dir2))+X_3;
    Y_6=3*shift*(sin(dir2))+Y_3;
    
    
    if dir1==1.57  
    %%% third Leg

    X_7=X_6;
    Y_7=Y_6-shift;
    X_8=X_6;
    Y_8=Y_6-2*shift;
    X_9=X_6;
    Y_9=Y_6-3*shift;
    
    %%% fourth Leg

    X_10=X_9+shift;
    Y_10=Y_9;
    X_11=X_9+2*shift;
    Y_11=Y_9;
    X_12=X_9+3*shift;
    Y_12=Y_9;
    
    elseif dir1==4.71
    %%% third Leg

    X_7=X_6;
    Y_7=Y_6+shift;
    X_8=X_6;
    Y_8=Y_6+2*shift;
    X_9=X_6;
    Y_9=Y_6+3*shift;
    
    %%% fourth Leg

    X_10=X_9-shift;
    Y_10=Y_9;
    X_11=X_9-2*shift;
    Y_11=Y_9;
    X_12=X_9-3*shift;
    Y_12=Y_9;
        
    else
    %%% third Leg
    dir3=dir(3);
    X_7=shift*(cos(dir3))+X_6;
    Y_7=Y_6;
    X_8=2*shift*(cos(dir3))+X_6;
    Y_8=Y_6;
    X_9=3*shift*(cos(dir3))+X_6;
    Y_9=Y_6;
    
    %%% fourth Leg
    dir4=dir(4);
    X_10=X_9;
    Y_10=shift*(sin(dir4))+Y_9;
    X_11=X_9;
    Y_11=2*shift*(sin(dir4))+Y_9;
    X_12=X_9;
    Y_12=3*shift*(sin(dir4))+Y_9;
    end
    
    Shape_Pts=[X_1 Y_1;X_2 Y_2;X_3 Y_3;X_4 Y_4;...
        X_5 Y_5;X_6 Y_6;X_7 Y_7;X_8 Y_8;...
        X_9 Y_9;X_10 Y_10;X_11 Y_11;X_12 Y_12];
    
elseif Shape_stp==111 % fixed line distance with diferent direction     
    
    prompt111 = {'line Direction'};
    dlg_title111 = 'line Direction';
    dir=str2double(inputdlg(prompt111,dlg_title111));
    X=Shift*(cos(dir))+X_start;
    Y=Shift*(sin(dir))+Y_start;
%         Shape_Pts=[X Y];
    Shape_Pts=[X Y];
    
else % assign n random targets for a constant shift (click n times for different locations)
    dir=[5.9 2.57 0.1 2.9 5.7 3.11 6.2 0.5 2.2 3.5];
    
    prompt3 = {'assign n random targets'};
    dlg_title3 = 'assign n random targets';
    Shape_stp=str2double(inputdlg(prompt3,dlg_title3));
    Shape_Pts=[];p=1;
    X=X_start;Y=Y_start;
    for i=1:Shape_stp

        X=Shift*(cos(dir(i)))+X;
        Y=Shift*(sin(dir(i)))+Y;
        Shape_Pts=[Shape_Pts; X Y];
    end
    
    hold on
    scatter(X_start,Y_start,'*')
    for i=1:Shape_stp
    plot(Shape_Pts(i,1),Shape_Pts(i,2),'o')
    end
    hold off
    for i=1:Shape_stp
        text(Shape_Pts(i,1)+10,Shape_Pts(i,2)+10,num2str(i),'Color','r')%Plot Step Numbers
    end
        

end
dlmwrite([my_dir,num2str(File_N),')\Shape_Pts.txt'],Shape_Pts); %save shape points.
end










